Include([[Data/levels/include/level_utils.lua]])
Include([[Data/levels/include/general_utils.lua]])

Level =
{
	MapSkinFilename = [[hatchery.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission9.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 30.0,
		PointGainPerCapture = 7,
		StartBuildPoints    = 20
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
		DisableLockdown = true,         --Turn off emergency help is player is behind
		NoAdvance       = false,        --Do not allow player to capture points
		HiveCtrAttack   = false,        --Send alien spawn to undefended alien hives
		SmartMutations	= true,			--Activate mutations using AI
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 9,
		Default = [[inactive]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)
        DeactivateAllMutations()
        --CreateDefenseTeams()
        
       --GameWorld:GetEntityById("bossHive"):SetDefensiveSpawn(CHiveBoss.ST_BRUTE)
       
	end
}

dialogueSaid = {}

cratesList = {}
crateInterceptTeamList = {}
totalCrates = 0

samplePathMarkerHdl = nil

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		KillBossObjective:Enable()
		
		--ScriptMgr:DoDelayedCall(2000, function () GameWorld:ApplyNextMutation(true); end) --Random Mutation
		
		--Adjust bioweapon crates
        local entCount = GameWorld:GetEntityCount()
        for i=0,entCount-1 do
            local ent = GameWorld:GetEntityByIndex(i)
            
            if ent then
                local crate = ent:ToCPropCrate()
                if crate then
                    crate:SetActivation(true)
                    crate:SetCrateDrag(0.0)
                    table.insert(cratesList, crate:GetHandle())
                    
                    crateInterceptTeamList[crate:GetId()] = {}
					totalCrates = totalCrates + 1
                end
            end
        end
		
		DestroyTrigger:Enable()
		CaptureAndLossTracker:Enable()
		StartMutationTimer()
		
		GameWorld:AddObjective("crateObj", "Disable mutations with bioweapon crates")
	    GameWorld:SetEntityVisible("crateDest", true)
		GameWorld:CreateTrainingArrow("crateDest")
		
		local startEnt = GameWorld:GetEntityById("sampleBox")
		local endEnt = GameWorld:GetEntityById("crateDest")
		samplePathMarkerHdl = GameWorld:CreatePathMarker(startEnt:GetPos(), endEnt:GetPos()):GetHandle()  
		
		CreateDefenseTeams()
		
		LevelUtils.ShowTimedDialogue("Damn, the bioweapon pods are scattered all over the place\n\nWe can use them to cancel mutations, but we have to find them first", "Scout", 15000)
		
		self:Disable()
	end)
LevelInit:Enable()

-------------------------------------------------------------------------------------- func Deactivate all alien mutations and start bioweapon timer
function DeactivateAllMutations()
    local mutationCount = #MutationWatcher.mutationList
    for i=1, mutationCount do
        GameWorld:DeactivateMutation(MutationWatcher.mutationList[i], false)
    end
    MutationWatcher.mutationList = {}
    
    if mutationCount <= 3 then
        LevelUtils.ShowTimedDialogue("Wait for more mutations, commander!\n\nBioweapons will work longer that way", "Scout", 15000)
    end
    
    if mutationCount >= 10 then
        SteamAchievements:SetAchievement("BEAT_ENDGAME_EXTRA_HARD")
    end
    
    GameWorld:SetRule("NoTowerRespawn", true)
    GameWorld:SetSpawnRate(0.0)
    
    GameWorld:GetEntityById("bossHive"):SetBleeding(true)
    
    local mutationTimeBonus = math.floor(math.pow(mutationCount, 1.3)*14000)
    local bioweaponDuration = 10000 + mutationTimeBonus + (CaptureAndLossTracker.top_score - CaptureAndLossTracker.current_score) * 30000
    
    if not bioweaponTimeout and not GetIsBossBattleOn() then
        if currentTimer then
            currentTimer:Disable()
            GameWorld:SetEventIndicator("")
        end
    
        ScriptMgr:DoDelayedCall(1000,
            function ()
                GameWorld:MakeAnnouncement("MUTATIONS\nCANCELLED")
            end)  
    
        currentTimer = LevelUtils.CreateTimer(bioweaponDuration, "Bioweapon Active for %s",
            function()
            
                GameWorld:SetSpawnRate(30.0)
            
                currentTimer:Disable()
                currentTimer = nil
                
                bioweaponTimeout = false
                GameWorld:SetRule("NoTowerRespawn", false)
                
                GameWorld:GetEntityById("bossHive"):SetBleeding(false)
                
                StartMutationTimer()
            end)
            
        bioweaponTimeout = true           
    elseif currentTimer then
        currentTimer:ResetTimer(bioweaponDuration + currentTimer:GetTimerLeft())
    end
      
end

-------------------------------------------------------------------------------------- func Check crates for bioweapon explosion
function PropCrateUpdateScript(p_milliseconds)
    
    filter_inplace(cratesList, function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
    
    local destEnt = GameWorld:GetEntityById("bossHive")
    if not destEnt then
        return
    end
        
    for i=1,#cratesList do
    
        local crateEnt = cratesList[i]:GetPtr()
        if crateEnt then   
            crateEnt = crateEnt:ToCPropCrate()
            if crateEnt then
            
            	filter_inplace(crateInterceptTeamList[crateEnt:GetId()],
            		function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
            	
            
                local crateAttached = crateEnt:GetAttachedActivator() ~= nil
                local explosionDist = 30.0
                
                if not crateAttached then explosionDist = explosionDist + 10.0 end
                
                if vect2f.IsDistLess(crateEnt:GetPos(), destEnt:GetPos(), explosionDist) then
                    DeactivateAllMutations()
                    CreateBioweaponExplosion(crateEnt:GetPos(), true)
                    
                    GameWorld:SetEntityVisible("crateDest", false)
                    GameWorld:RemoveTrainingArrow("crateDest")
                    GameWorld:ChangeObjectiveStatus("crateObj", [[complete]])
                    
                    if samplePathMarkerHdl then
                        local ent = samplePathMarkerHdl:GetPtr();
                        if ent then
                            ent:Kill()
                        end
                    end
                    
                    crateEnt:Kill()
                end
            end
        end
    end
    
end
--ScriptMgr:SetUpdateCallback(PropCrateUpdateScript)
ScriptMgr:DoDelayedCall(400,
    function ()
        PropCrateUpdateScript(400)
        return true
    end) 

------------------------------------------------------------------------------- Crate Counterattack Trigger (Spawn clones on towing)
CrateCounterattackScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_POWERUP_TOWED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        local crate = GameWorld:GetEntityById(p_entId)
        if not crate then
            return
        end
        
        crate = crate:ToCPropCrate();
        if not crate then
            return
        end        
        
        local crateAttackList = crateInterceptTeamList[p_entId]
        local alienCount = 4 - #crateAttackList
        if alienCount <= 0 then
        	alienCount = 0
       	end
        
        local marine = crate:GetAttachedActivator()
        if not marine then
            return
        end  

        marine = marine:ToCHuman()
        if not marine or not marine:GetIsPlayerControlled() then
            return
        end
        
        -- Apply shield so that fights near the hive will be easier
        marine:ApplyInvulnerability(6000)
        
        local startEnt = GameWorld:GetEntityById("bossHive") --GameWorld:GetZombieAttackSpawnEntity(2, marine:GetPos(), false)
        if startEnt == nil  then
            return
        end
        
       
        for i=1,alienCount do
            local offsetDelta = vect2f.MakePolar(GetRandomRange(3.0, 4.0), i/alienCount*math.pi*2)
            local alienMarine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + offsetDelta)
            alienMarine:SetSpeedMultiple(2.0)
            alienMarine:SetDegeneration(false)
            
            table.insert(crateAttackList, alienMarine:GetHandle())
        end
     
        for i=1,#crateAttackList do
        	local handle = crateAttackList[i]
        	local entity = handle:GetPtr()
        	
        	if entity then
        		local alienMarine = entity:ToCHuman()
        		
        		if alienMarine then
        			alienMarine:CommandFocusAttack(marine, marine:GetPos())
        		end
        	end
        end
        	 
	end)
CrateCounterattackScript:Enable()


------------------------------------------------------------------------------- Mutation has happened! Record it
MutationWatcher = LevelUtils.MakeGoal(
	function (self)
		MutationWatcher.mutationList = {}
	end,
	
	{[[NT_MUTATION_EVOLVED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        table.insert(self.mutationList, p_other)
		
		if #MutationWatcher.mutationList == 5 and not dialogueSaid["USE_BIOWEAPON"] then
            LevelUtils.ShowTimedDialogue("Perhaps it is time to deploy the bioweapon\n\nAny more, and we risk being overrun", "Scout", 15000)
            dialogueSaid["USE_BIOWEAPON"] = true
        elseif #MutationWatcher.mutationList == 9 and not dialogueSaid["USE_BIOWEAPON2"] then
            LevelUtils.ShowTimedDialogue("USE THE BIOWEAPON NOW!\n\nWe're knee deep in bugs over here", "Sarge", 15000)
            dialogueSaid["USE_BIOWEAPON2"] = true
        end
		
	end)
MutationWatcher:Enable()

-------------------------------------------------------------------------------------- func Start timer for next mutation
bioweaponTimeout = false
currentTimer = nil
function StartMutationTimer()
    if bioweaponTimeout or GetIsBossBattleOn() then
        return
    end

    local timerK = 1.0 - math.pow(math.max(0, CaptureAndLossTracker.current_score) / CaptureAndLossTracker.totalCapPoints, 1.5) * 0.7
    Log("timerK = " .. timerK)
    if CaptureAndLossTracker.current_score < CaptureAndLossTracker.top_score then
        timerK = 1.2
    end
    
    local timerLength = timerK * (10000 + #MutationWatcher.mutationList*15000)    
    currentTimer = LevelUtils.CreateTimer(timerLength, "Mutation in %s",
        function()
        
            GameWorld:ApplyNextMutation(true)
        
            currentTimer:Disable()
            currentTimer = nil
            ScriptMgr:DoDelayedCall(5000, StartMutationTimer)
        end)
end

function ApplyPermanentBioweapon()

    GameWorld:SetSpawnRate(0.0)

    if currentTimer then
        currentTimer:Disable()
        currentTimer = nil
    end    
    
    GameWorld:SetRule("NoTowerRespawn", true)
    GameWorld:SetRule("NoPushback", true)    
    
    GameWorld:GetEntityById("bossHive"):SetBleeding(true)

end

-------------------------------------------------------------------------------------- func Create a marine
function CreateMarine(p_type, p_spawnEntId, p_offset)

    local startEnt = GameWorld:GetEntityById(p_spawnEntId)
    if startEnt == nil then
        return
    end

    local marine = GameWorld:CreateEntity(p_type, "", startEnt:GetPos() + p_offset)
    
    marine:SetDegeneration(false)

    return marine
end

-------------------------------------------------------------------------------------- func Order marine to go through waypoints
function OrderMarineWaypoints(p_marinePtr, p_waypointIdList, p_offset)

    local firstPoint = true
    for i=1, #p_waypointIdList do
        local waypointId = p_waypointIdList[i]
        
        local waypointEnt = GameWorld:GetEntityById(waypointId)
        if waypointEnt ~= nil then
            p_marinePtr:SendCommand(ICommandable.CT_ATTACKMOVE, waypointEnt:GetPos() + p_offset, nil, firstPoint ~= true)
            firstPoint = false
        end
     
    end      
end

-------------------------------------------------------------------------------------- func Create an entire marine team
function CreateMarineTeam(p_type, p_spawnEntId, p_waypointIdList, p_teamSize)

    local startEnt = GameWorld:GetEntityById(p_spawnEntId)
    if startEnt == nil then
        return
    end

    local teamHandles = {}
    for i=1, p_teamSize do
        local offsetDelta = vect2f.MakePolar(7.0, i/p_teamSize*math.pi*2)
        
        local marine = CreateMarine(p_type, p_spawnEntId, offsetDelta)
        
        OrderMarineWaypoints(marine, p_waypointIdList, offsetDelta)
        
        table.insert(teamHandles, marine:GetHandle())
    end
    
    return teamHandles
end

marineTeamList = {}

------------------------------------------------------------------------------- Bunker Destroy Trigger
DestroyTrigger = LevelUtils.MakeGoal(
	function (self)
	    self.bunkers_max = 5
	    self.bunkers_captured = 0
	
		GameWorld:AddObjective("bunkerObj", "Reclaim marine barracks (" .. self.bunkers_captured .. "/" .. self.bunkers_max .. ")")
		
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if not string.starts(p_entId, "bunker") then
			return
		end
		
		self.bunkers_captured = self.bunkers_captured + 1
		GameWorld:ChangeObjectiveText("bunkerObj", "Reclaim marine barracks (" .. self.bunkers_captured .. "/" .. self.bunkers_max .. ")")
		if self.bunkers_captured == self.bunkers_max then
		    GameWorld:ChangeObjectiveStatus("bunkerObj", [[complete]])
        end
		
		--Dialogue
		local dialogueBank = {  "Good shootin\n\nNow we've got some friends to watch our back.",
		                        "Heh\n\nMaybe I'll go into demolition after this",
                                "Once this is all over, I'm settlin down\n\nMan can only shoot so many buggers in his life.",
                                "Another barrack up\n\nThis party's gettin crowded.  Anyone got drinks?",
                                "Got all five barracks back up?\n\nGood. Time to put a dent into the big beastie."}
                                
        if dialogueBank[self.bunkers_captured] then
		    LevelUtils.ShowTimedDialogue(dialogueBank[self.bunkers_captured], "Sarge", 8000)
		end
		
		--Clear out aliens in the radius around the new bunker
        local entities = {}
        GameWorld:AreaQuery(p_pos, 15.0, entities)
        for i=1, #entities do
            if  entities[i]:GetNotable() and
                not entities[i]:GetIsFriendly(CEntity.GetPlayerTeam()) and
                not entities[i]:GetBuilding() then
            
                entities[i]:DamageKill()
            end
        end
		
        local bunker = GameWorld:CreateEntity("PropBuilding", "", p_pos)
        
        --GameWorld:RegisterRaidTarget(bunker)
        GameWorld:RegisterRespawnSource(bunker)
        
        local building = bunker:ToCHumanBuilding()
        building:CompleteBuilding()
        --building:SetIsInvisible(true)
        
        local bunkerHdl = bunker:GetHandle()
        ScriptMgr:DoImmideateLoopedCall(90000, 
            function()
                local bunker = bunkerHdl:GetPtr()
                if not bunker then
                    return false
                end
                
                local waypointList = {}
                local startEnt = GameWorld:GetZombieAttackSpawnEntity(2, bunker:GetPos(), false)
                if startEnt then
                    table.insert(waypointList, startEnt:GetId())
                end
                
                table.insert(waypointList, "bossHive")
                
                local marineCount = 3
                if marineTeamList[bunker:GetId()] ~= nil then
                    filter_inplace(marineTeamList[bunker:GetId()], function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
                    marineCount = marineCount - #marineTeamList[bunker:GetId()]
                else
                    marineTeamList[bunker:GetId()] = {}
                end
                
                if marineCount > 0 then
                    local teamHandles = CreateMarineTeam("AIMarine", bunker:GetId(), waypointList, marineCount)
                    for i=1, #teamHandles do
                        table.insert(marineTeamList[bunker:GetId()], teamHandles[i])
                    end
                end


                return true                                       
            end)
     
	end,
	
	function (self)
	end) 

------------------------------------------------------------------------------- Capture and Loss Tracker
CaptureAndLossTracker = LevelUtils.MakeGoal(
	function (self)
		self.current_score = 0
		self.top_score = 0
		self.totalCapPoints = 0
		
        local entCount = GameWorld:GetEntityCount()
        for i=0,entCount-1 do
            local ent = GameWorld:GetEntityByIndex(i)
            
            if ent then               
				local capPt = ent:ToCCapturePoint()
				if capPt and not capPt:IsLocked() then
					self.totalCapPoints = self.totalCapPoints + 1
				end
            end
        end
	end,
	
	{[[NT_POINT_CAPTURED]], [[NT_POINT_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        if p_type == [[NT_POINT_CAPTURED]] then
            self.current_score = self.current_score + 1
        end
        
        if p_type == [[NT_POINT_LOST]] then
            self.current_score = self.current_score - 1
        end
        
        if self.current_score > self.top_score then
            self.top_score = self.current_score
            
            if self.top_score == self.totalCapPoints then
                ScriptMgr:DoDelayedCall(1000,
                function ()
                    GameWorld:MakeAnnouncement("THE HARVESTER\nIS VULNERABLE")
                end) 
                
                ApplyPermanentBioweapon()
                StartBossSpawning()
                
                LevelUtils.ShowTimedDialogue("Poison. Venom. Blight. Toxin. Corruption.\nDisease. Pestilence. Affliction. Virus.\nBlight. Venom. Disease. Death.", "Alien", 8000)
            end
        end
	end)


-------------------------------------------------------------------------------------- func Update boss invulnerability
function GetIsBossBattleOn()
    return CaptureAndLossTracker.current_score >= CaptureAndLossTracker.totalCapPoints
end

function BossUpdate(p_milliseconds)

    local boss = GameWorld:GetEntityById("bossHive")
    if boss then
        local godModeOn = not GetIsBossBattleOn()
    
        boss:SetGodMode(godModeOn)
        boss:SetDamageResistance(0.75)
    end
    
end
--ScriptMgr:SetUpdateCallback(BossUpdate)
ScriptMgr:DoDelayedCall(400,
    function ()
        BossUpdate(400)
        return true
    end) 


function ApplyImpulseExplosion(p_pos, p_radius, p_impulse)

    local entities = {}
    GameWorld:AreaQuery(p_pos, p_radius, entities)
    for i=1, #entities do
        if  entities[i]:GetNotable() and
            entities[i]:GetIsFriendly(CEntity.GetPlayerTeam()) then
        
            local impulseVec = entities[i]:GetPos() - p_pos
            impulseVec:Normalize()

            entities[i]:ApplyImpulse(impulseVec * p_impulse)
        end
    end   

end

function StartBossSpawning()
    local boss = GameWorld:GetEntityById("bossHive")
    if not boss then
        return
    end
    
    RespawnDefenseTeams()
    boss:SetDefensiveSpawn(CHiveBoss.ST_SPITTER)

    local bossHandle = boss:GetHandle()
    LevelUtils.CreateEntityHPMonitor(bossHandle, {0.75, 0.50, 0.25},
        function (p_hpFract)

            local boss = bossHandle:GetPtr()
            if not boss then
                return
            end

            if p_hpFract == 0.75 then
                LevelUtils.ShowTimedDialogue("Not so tough now that you're full of the Doc's magic mix are ya?", "Sarge", 8000)
                boss:SetDefensiveSpawn(CHiveBoss.ST_KAMI)
            elseif p_hpFract == 0.50 then
                LevelUtils.ShowTimedDialogue("Drake, stop talking to the thing and kill it!\n\nYou can write it a postcard afterward.", "Scout", 8000)
                boss:SetDefensiveSpawn(CHiveBoss.ST_BRUTE)
            elseif p_hpFract == 0.25 then
                LevelUtils.ShowTimedDialogue("There is a time for everything\n    a time to plant and a time to uproot\n\n  a time to be born and a time to die", "Alien", 8000)
                boss:SetDefensiveSpawn(CHiveBoss.ST_ZOMBIE)
            end
            
            boss:LockMaxHPFraction(p_hpFract)
            RespawnDefenseTeams()
            
            ApplyImpulseExplosion(boss:GetPos(), 80.0, 800.0)
            CreateBioweaponExplosion(boss:GetPos(), false)
            
        end)

end

------------------------------------------------------------------------------- Kill the Boss hive objective
KillBossObjective = LevelUtils.MakeGoal(
	function (self)
    
	    GameWorld:AddObjective("bossObj", "Destroy the giant hive")
	    
    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "bossHive" then
            return
        end

        ApplyImpulseExplosion(p_pos, 80.0, 800.0)
        CreateBioweaponExplosion(p_pos, false)

        GameWorld:ChangeObjectiveStatus("bossObj", [[complete]])

        local text_hdl = GameWorld:ShowText("So... You think they give medals for saving mankind?\n\nI'll take two.", "Sarge")
		ScriptMgr:DoDelayedCall(5000,
            function()
                GameWorld:GameOver(true)
                GameWorld:ClearText()
            end)
            
        if currentTimer then
            currentTimer:Disable()
            GameWorld:SetEventIndicator("")
        end

	end,
	
	function (self)
	end)
	
------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		KillBossObjective:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()


-------------------------------------------------------------------------------------- func Create cascading bioweapons explosion
function CreateSingleExplosionPuff(p_pos, p_scale, p_grading)

    local animEffect = GameWorld:CreateAnimationEffect(p_pos, GetRandomRange(0.0, 360.0), "BWPuff", "BioweaponPuff");

    animEffect:SetScale(p_scale)
    animEffect:SetTimeGrading(p_grading) --GetRandomRange(1.2, 1.7))
    animEffect:SetAngularVelocity(GetRandomRange(-360, 360) * 3.0)
    
    --animEffect:SetDrawLayer(DL_EFFECTS6)


    GameWorld:CreatePoisonDecal(p_pos, 2.5)

    --CAudioEngine::Instance().ReportAudioEvent("MineExplosion", GetPos())

    return animEffect   

end

function CreateExplosionArc(p_delay, p_pos, p_radius, p_startAngle, p_endAngle)
    
    local explosionDiameter = 3.0

    ScriptMgr:DoDelayedCall(p_delay, 
        function()
            local circumference = (p_endAngle - p_startAngle) * p_radius
            local numExplosions = math.floor(circumference / explosionDiameter) * 5
            
            if numExplosions <= 0 then
                return false
            end
            
            for i=0, numExplosions do
                local lerpK = ((i + GetRandomRange(-0.3, 0.3)) / numExplosions)
                local angle = p_startAngle * (1-lerpK) + p_endAngle * (lerpK)
                
                local radius = p_radius + explosionDiameter * GetRandomRange(-0.3, 0.3)
                local delta = vect2f.MakePolar(radius, angle)
                local ent = CreateSingleExplosionPuff(p_pos + delta, explosionDiameter / 2, 0.8 + p_radius / 30.0)
                
                delta:Normalize()
                delta = delta / math.max(radius, 5.0) * 100
                delta:Rotate(GetRandomRange(-1.3, 1.3))
                
                ent:SetVel(delta)
            end

            if p_radius < 100.0 then
                local arcJitter = {GetRandomRange(0.5, 1.5), GetRandomRange(0.5, 1.5)}
                local lerpK = GetRandomRange(0.3, 0.7)
                local midAngle = p_startAngle * (1-lerpK) + p_endAngle * (lerpK)
                
                CreateExplosionArc(p_delay, p_pos, p_radius + explosionDiameter * arcJitter[1], p_startAngle, midAngle)
                CreateExplosionArc(p_delay, p_pos, p_radius + explosionDiameter * arcJitter[2], midAngle, p_endAngle)
            end

            return false                                       
        end)   

end

function CreateBioweaponExplosion(p_pos, p_doDamage)

    GameWorld:ShakeCamera(10.0, 50, p_pos)
    CreateExplosionArc(25, p_pos, 2.0, 0.0, math.pi*2)

    --Clear out aliens in the radius around the explosion
    if p_doDamage then
        local entities = {}
        GameWorld:AreaQuery(p_pos, 30.0, entities)
        for i=1, #entities do
            if  entities[i]:GetNotable() and
                not entities[i]:GetIsFriendly(CEntity.GetPlayerTeam()) and
                entities[i]:GetId() ~= "bossHive"
             --[[and
                not entities[i]:GetBuilding()--]] then
            
                entities[i]:DamageKill()
            end
        end
        
        ApplyImpulseExplosion(p_pos, 30.0, 400.0)
    end

    AudioEngine.ReportAudioEvent([[BlastExplosion]])
end


------------------------------------------------------------------------ Boss Hive teams

bossHiveTeams = {}


function CreateHiveDefenseTeam(p_bossHiveHdl, p_baseOffset)

    local alienTeam = {}
    
    alienTeam.bossHiveHandle = p_bossHiveHdl
    alienTeam.baseOffset = p_baseOffset
    alienTeam.teamHandles = {}
    
    function alienTeam:Update()
    
        filter_inplace(self.teamHandles, function(p_handle) return p_handle and p_handle:GetPtr() ~= nil end)
    
        local startEnt = self.bossHiveHandle:GetPtr()
        if startEnt == nil then
            return
        end
    
        for i=1,#self.teamHandles do
            local marine = self.teamHandles[i]:GetPtr()
            
            if marine and marine:GetIsIdle() then
                marine:CommandProtect(startEnt, marine:GetPos() - startEnt:GetPos())
            end
        end        
    
    end
    
    function alienTeam:AddTeamMember(p_marinePtr)
        for i=1,#self.teamHandles do
            local marine = self.teamHandles[i]:GetPtr()
            
            if marine then
                p_marinePtr:AddTeammate(marine)
                marine:AddTeammate(p_marinePtr)
            end
        end
    
        table.insert(self.teamHandles, p_marinePtr:GetHandle())
    end
    
    function alienTeam:GetMemberCount()
        return #self.teamHandles
    end    

    function alienTeam:CreateAlienMarine(p_offset)

        local startEnt = self.bossHiveHandle:GetPtr()
        if startEnt == nil then
            return
        end

        local spawnOffset = vect2f(self.baseOffset)
        spawnOffset:Normalize()
        spawnOffset = spawnOffset * startEnt:GetRadius() * 0.8
        
        local marine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + spawnOffset + p_offset * 0.5)-- + self.baseOffset + p_offset)      
        marine:SetDegeneration(false)

        self:AddTeamMember(marine)

        marine:SendCommand(ICommandable.CT_ATTACKMOVE, startEnt:GetPos() + self.baseOffset + p_offset, nil, true)
    end

    return alienTeam
end

function CreateDefenseTeams()
    local boss = GameWorld:GetEntityById("bossHive")
    if not boss then
        return
    end
    
    local defenseRadius = 24.0
    local numTeams = 5
    for i=1,numTeams do
        local offset = vect2f.MakePolar(defenseRadius, i/numTeams*math.pi*2)
        
        local team = CreateHiveDefenseTeam(boss:GetHandle(), offset)
        table.insert(bossHiveTeams, team)
    end    

    RespawnDefenseTeams()

end

function RespawnDefenseTeams()

    for j=1, #bossHiveTeams do
        local team = bossHiveTeams[j]
    
        local offset = vect2f(team.baseOffset)
        offset:Normalize()
        offset:Rotate90CW()
    
        local teamSize = math.floor(CaptureAndLossTracker.top_score / 2) + 1
        for i=team:GetMemberCount()+1, teamSize do
            local iEven = (i % 2 == 0)
            local length = (i - (i % 2)) / 2
            
            if not iEven then length = length * -1 end
            
            team:CreateAlienMarine(offset * length * 5.5)
        end
    end    

end

ScriptMgr:DoDelayedCall(60000,
    function ()
        if not GetIsBossBattleOn() then
            RespawnDefenseTeams()
        end
        
        return not GetIsBossBattleOn()
    end) 

function DefenseTeamsUpdate(p_milliseconds)

    for i=1, #bossHiveTeams do
        bossHiveTeams[i]:Update()
    end
    
end
--ScriptMgr:SetUpdateCallback(BossUpdate)
ScriptMgr:DoDelayedCall(400,
    function ()
        DefenseTeamsUpdate(400)
        return true
    end) 